{:extends file="groupuser_layout.tpl"}
{:block name="header_css" append}
    <link rel="stylesheet" href="/Public/static/admin/lib/DataTables-1.10.12/media/css/dataTables.bootstrap4.min.css">
    <link rel="stylesheet" href="/Public/static/admin/lib/DataTables-1.10.12/extensions/Buttons/css/buttons.bootstrap4.css">
{:/block}
{:block name="content_title"}
{:/block}
{:block name="content_breadcrumb"}
    首页
{:/block}
{:block name="content_body"}
    <div class="panel panel-default">
        <div class="panel-heading">
        </div>
        <div class="panel-body">
            <div class="table-responsive">
                <table class="table table-striped table-bordered" id="users_table">
                        <thead>
                        <tr>
                            <th>id</th>
                            <th>姓名</th>
                            <th>业务号</th>
                            <th>生成时间</th>
                        </tr>
                        </thead>
                        <tbody class="text-left">
                        {:foreach from=$list item=item}
                            <tr id="{:$item.id}">
                                <td>{:$item.id}</td>
                                <td>{:$item.name}</td>
                                <td>{:$item.business}</td>
                                <td>{:$item.addtime|date_format:'%Y-%m-%d %H:%M:%S'}</td>
                            </tr>
                        {:/foreach}
                        </tbody>
                </table>
            </div>
        </div>
    </div>

<div class="modal fade" id="confirmModel">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
                <h4 class="modal-title">警告</h4>
            </div>
            <div class="modal-body">
                <p>确定要删除吗?</p>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">取消</button>
                <button type="button" class="btn btn-primary" id="confirm_btn_certain">确定</button>
            </div>
        </div><!-- /.modal-content -->
    </div><!-- /.modal-dialog -->
</div><!-- /.modal -->

{:/block}



{:block name="body_js" append}
    <script type="text/javascript" language="javascript" src="/Public/static/admin/lib/DataTables-1.10.12/media/js/jquery.dataTables.min.js"></script>
    <script type="text/javascript" language="javascript" src="/Public/static/admin/lib/DataTables-1.10.12/media/js/dataTables.bootstrap4.min.js"></script>
    <script type="text/javascript" language="javascript" src="/Public/static/admin/lib/DataTables-1.10.12/extensions/Buttons/js/dataTables.buttons.min.js"></script>
    <script type="text/javascript" language="javascript" src="/Public/static/admin/lib/DataTables-1.10.12/extensions/Buttons/js/buttons.bootstrap4.min.js"></script>


    <script type="text/javascript" language="javascript" src="/Public/static/admin/lib/DataTables-1.10.12/extensions/Buttons/js/buttons.html5.min.js"></script>
    <script type="text/javascript" language="javascript" src="/Public/static/admin/lib/DataTables-1.10.12/extensions/Buttons/js/buttons.print.min.js"></script>
    <script type="text/javascript" language="javascript" src="/Public/static/admin/lib/DataTables-1.10.12/extensions/Buttons/js/buttons.colVis.min.js"></script>

    <script>
        $(document).ready(function() {
            var table = $('#users_table').DataTable({
                'bSort': false,
                "pagingType":   "full_numbers",
                lengthChange: false,
                buttons: [
                    {
                        extend: 'csvHtml5',
                        text: 'CSV',
                        exportOptions: {
                            stripHtml: false
                        }
                    },
                    {
                        extend: 'excelHtml5',
                        text: 'Excel',
                        exportOptions: {
                            stripHtml: false
                        }
                    }
                ],
                "bLengthChange": false,
                "iDisplayLength": 15,
                'language': {
                    "sProcessing": "处理中...",
                    "sLengthMenu": "显示 _MENU_ 项结果",
                    "sZeroRecords": "没有匹配结果",
                    "sInfo": "显示第 _START_ 至 _END_ 项结果，共 _TOTAL_ 项",
                    "sInfoEmpty": "显示第 0 至 0 项结果，共 0 项",
                    "sInfoFiltered": "(由 _MAX_ 项结果过滤)",
                    "sInfoPostFix": "",
                    "sSearch": "搜索:",
                    "sUrl": "",
                    "sEmptyTable": "表中数据为空",
                    "sLoadingRecords": "载入中...",
                    "sInfoThousands": ",",
                    "oPaginate": {
                        "sFirst": "首页",
                        "sPrevious": "上页",
                        "sNext": "下页",
                        "sLast": "末页"
                    },
                    "oAria": {
                        "sSortAscending": ": 以升序排列此列",
                        "sSortDescending": ": 以降序排列此列"
                    }
                }
            });
            table.buttons().container().appendTo( '#users_table_wrapper .col-md-6:eq(0)' );

            jQuery("select").chosen({
                'min-width': '100px',
                'white-space': 'nowrap',
                disable_search_threshold: 10
            });


            var rows = null;

            $('#users_table tbody').on('click', '.btn-delete', function () {
                console.log('delte');
                $('#confirmModel').modal();
                rows = table.row($(this).parents('tr'));

            });

            $('#confirm_btn_certain').on('click', function () {
                console.log(rows.ids().toArray());
                var data = {
                    id: rows.ids().toArray()[0]
                };
                $.post('/admin/prize/deletePrize',data, function (resp) {
                    if (resp.status == 1) {
                        $('#confirmModel').modal('hide');
                        rows.remove().draw(false);
                    }
                })
            });

        });
    </script>
{:/block}