<?php

if (!defined('THINK_PATH')) {
    die('Hacking attempt');
}

function session_uid()
{
    return session('uid');
}


function smarty_function_resource($params, Smarty_Internal_Template $template)
{
    $type = $params['type'];
    $file = $params['file'];
    if (array_key_exists('domain', $params)) {
        $domain = $params['domain'];
    } else {
        $domain = null;
    }
    if (empty($file)) {
        trigger_error("static_resource: function call file not allowed", E_USER_ERROR);
        return '';
    }
    // 'Module://you_file_path'
    if (preg_match('#(.*?)@(.*?)://(.*?)$#', $file, $m)) {
        $url = '/Apps/' . $m[1] . '/Group' . $m[2] . '/' . $m[3];
        $file = WEB_ROOT_PATH . $url;
    } elseif (preg_match('#__ROOT__://(.*?)$#', $file, $m)) {
        $url = '/' . $m[1];
        $file = WEB_ROOT_PATH . '/' . $m[1];
    } else {
        trigger_error("static_resource: function call file not allowed", E_USER_ERROR);
    }
    $url = str_replace('//', '/', $url);
    if ($domain) {
        $url = C('SITE_URL') . $url;
    }
    $mtime = filemtime($file);
    if ($mtime === null) {
        return '<!-- ' . $params['file'] . ' NOT FOUND! -->';
    }
    if ($type == 'css') {
        return <<<END
<link rel="stylesheet" type="text/css" href="$url?$mtime"/>
END;
    } elseif ($type == 'js') {
        return <<<END
<script src='$url?$mtime' type='text/javascript'></script>
END;
    } elseif ($type == 'image') {
        return "$url?$mtime";
    } elseif ($type == 'file') {
        return "$url?$mtime";
    } else {
        return '<!-- UNKNOWN type:$type! -->';
    }
}

// TODO(august) delete code
function smarty_function_static($params, Smarty_Internal_Template $template)
{
    // {static type=css|js|image file=xxxx}
    $type = $params['type'];
    $file = $params['file'];
    if (array_key_exists('domain', $params)) {
        $domain = $params['domain'];
    } else {
        $domain = null;
    }
    if (empty($file)) {
        trigger_error("static_resource: function call file not allowed", E_USER_ERROR);
        return '';
    }
    // __APP_RES__/js/a.js ==> AppsStatic/MODULE_NAME/Public/js/a.js
    // /Base/js/a.js
    // /Common/js/a.js
    $group = GROUP_NAME;
    if (strpos($file, '__BASE_RES__') === 0) {
        $module = 'Base';
        $left = str_replace('__BASE_RES__', '', $file);
    } elseif (strpos($file, '__APP_RES__') === 0) {
        $module = ADDON_APP_NAME;
        $left = str_replace('__APP_RES__', '', $file);
    } else {
        $pos = strpos($file, '/', 1);
        $module = str_replace('/', '', substr($file, 0, $pos + 1));
        $left = substr($file, $pos + 1);
    }
    foreach (array('Home', 'User', 'Wap', 'Admin') as $tmp_group) {
        if (stripos($left, "@$tmp_group/") !== false) {
            $group = $tmp_group;
            $left = str_ireplace("@$group/", '', $left);
            break;
        }
    }
    $url = "/Apps/$module/Group$group/Public/$left";
    if ($domain) {
        $url = C('SITE_URL') . $url;
    }
    $url = str_replace('//', '/', $url);

    $real_file = ADDON_PATH . $module . '/Group' . $group . '/Public' . $left;
    $mtime = filemtime($real_file);
    if ($mtime === null) {
        return '<!-- ' . $params['file'] . ' NOT FOUND! -->';
    }
    if ($type == 'css') {
        return <<<END
<link rel="stylesheet" type="text/css" href="$url?$mtime"/>
END;
    } elseif ($type == 'js') {
        return <<<END
<script src='$url?$mtime' type='text/javascript'></script>
END;
    } elseif ($type == 'image') {
        return "$url?$mtime";
    } else {
        return '<!-- UNKNOWN type:$type! -->';
    }
}