{:extends file="groupuser_layout.tpl"}
{:block name="header_css" append}
    <link rel="stylesheet" href="/Public/static/admin/lib/DataTables-1.10.12/media/css/dataTables.bootstrap4.min.css">
    <link rel="stylesheet"
          href="/Public/static/admin/lib/DataTables-1.10.12/extensions/Buttons/css/buttons.bootstrap4.css">
    <link rel="stylesheet"
          href="/Public/static/admin/lib/DataTables-1.10.12/extensions/Select/css/select.dataTables.min.css">
    <link rel="stylesheet"
          href="/Public/static/admin/lib/DataTables-1.10.12/extensions/RowReorder/css/rowReorder.dataTables.min.css">
    <style>
    </style>
{:/block}
{:block name="content_title"}
{:/block}
{:block name="content_breadcrumb"}
    首页
{:/block}
{:block name="content_body"}
    <div class="panel panel-default">
        <div class="panel-body">
            <div class="table-responsive">
                <table class="table table-condensed" id="users_table">
                    <thead>
                        <tr>
                            <th class="text-left col-sm-1">id</th>
                            <th class="text-left col-sm-2">姓名</th>
                            <th class="text-left col-sm-2">业务号</th>
                            <th class="text-left col-sm-2">生成时间</th>
                        </tr>
                    </thead>
                    <tbody class="text-left">
                    {:foreach $list as $item}
                        <tr id="{:$item.id}">
                            <td>{:$item.id}</td>
                            <td>{:$item.name}</td>
                            <td>{:$item.business}</td>
                            <td>{:$item.addtime|date_format:'%Y-%m-%d %H:%M:%S'}</td>
                            </tr>
                    {:/foreach}
                    </tbody>
                </table>
            </div>
        </div>
    </div>
{:/block}
{:block name="body_js" append}
    <script type="text/javascript" language="javascript"
            src="/Public/static/admin/lib/DataTables-1.10.12/media/js/jquery.dataTables.min.js"></script>
    <script type="text/javascript" language="javascript"
            src="/Public/static/admin/lib/DataTables-1.10.12/media/js/dataTables.bootstrap4.min.js"></script>
    <script type="text/javascript" language="javascript"
            src="/Public/static/admin/lib/DataTables-1.10.12/extensions/Buttons/js/dataTables.buttons.min.js"></script>
    <script type="text/javascript" language="javascript"
            src="/Public/static/admin/lib/DataTables-1.10.12/extensions/Buttons/js/buttons.bootstrap4.min.js"></script>
    <script type="text/javascript" language="javascript"
            src="/Public/static/admin/lib/DataTables-1.10.12/extensions/Select/js/dataTables.select.min.js"></script>
    <script type="text/javascript" language="javascript"
            src="/Public/static/admin/lib/DataTables-1.10.12/extensions/Buttons/js/buttons.html5.min.js"></script>
    <script type="text/javascript" language="javascript"
            src="/Public/static/admin/lib/DataTables-1.10.12/extensions/Buttons/js/buttons.print.min.js"></script>
    <script type="text/javascript" language="javascript"
            src="/Public/static/admin/lib/DataTables-1.10.12/extensions/Buttons/js/buttons.colVis.min.js"></script>
    <script type="text/javascript" language="javascript"
            src="/Public/static/admin/lib/DataTables-1.10.12/extensions/RowReorder/js/dataTables.rowReorder.min.js"></script>
    <script type="text/javascript" language="javascript"
            src="/Public/static/admin/js/validator.js"></script>
    <script type="text/javascript" language="javascript"
            src="/Public/static/admin/lib/plupload-2.1.9/js/plupload.full.min.js"></script>
    <script type="text/javascript" language="javascript"
            src="/Public/static/admin/lib/qiniu/dist/qiniu.min.js"></script>
    <script src="http://cdn.bootcss.com/json2/20150503/json2.min.js"></script>
    <script>
        
        $(document).ready(function () {
            var lesson_id = {:$lesson.id|default:0};
            var table = $('#users_table').DataTable({
            'bSort': false,
            "pagingType":   "full_numbers",
            lengthChange: false,
            buttons: [
                {
                    extend: 'csvHtml5',
                    text: 'CSV',
                    exportOptions: {
                        stripHtml: false
                    }
                },
                {
                    extend: 'excelHtml5',
                    text: 'Excel',
                    exportOptions: {
                        stripHtml: false
                    }
                }
            ],
            "bLengthChange": false,
            "iDisplayLength": 15,
            'language': {
                "sProcessing": "处理中...",
                "sLengthMenu": "显示 _MENU_ 项结果",
                "sZeroRecords": "没有匹配结果",
                "sInfo": "显示第 _START_ 至 _END_ 项结果，共 _TOTAL_ 项",
                "sInfoEmpty": "显示第 0 至 0 项结果，共 0 项",
                "sInfoFiltered": "(由 _MAX_ 项结果过滤)",
                "sInfoPostFix": "",
                "sSearch": "搜索:",
                "sUrl": "",
                "sEmptyTable": "表中数据为空",
                "sLoadingRecords": "载入中...",
                "sInfoThousands": ",",
                "oPaginate": {
                    "sFirst": "首页",
                    "sPrevious": "上页",
                    "sNext": "下页",
                    "sLast": "末页"
                },
                "oAria": {
                    "sSortAscending": ": 以升序排列此列",
                    "sSortDescending": ": 以降序排列此列"
                }
            }
        });
        table.buttons().container().appendTo( '#users_table_wrapper .col-md-6:eq(0)' );
        $('#users_table tbody').on('click', '.go-button', function () {
            var id = table.row($(this).parents('tr')).id();
            var _this = this;
            $.post('/Admin/Review/certain', {
                id: id
            }, function (resp) {
                console.log(resp);
                // table.row($(_this).parents('tr')).remove().draw( false );
                $(_this).parent().parent().remove();
            });
        });
    });
    </script>
{:/block}