function preloadimages(obj, complete_cb, progress_cb) {
    var loaded = 0;
    var toload = 0;
    var images = obj instanceof Array ? [] : {};
    toload = obj.length;
    for (var i = 0; i < obj.length; i++) {
        images[i] = new Image();
        images[i].src = obj[i];
        // console.log(obj[i]);
        images[i].onload = load;
        images[i].setAttribute('crossOrigin', 'anonymous');
        images[i].onerror = load;
        images[i].onabort = load;
    }
    if (obj.length == 0) {
        complete_cb(images);
    }

    function load() {
        ++loaded;
        if (progress_cb) {
            progress_cb(loaded / toload);
        }
        if (loaded >= toload) {
            complete_cb(images);
        }
    }
}

var picUrl = window.base_resource_url + '/images/';

var preloadImageList = [
    // picUrl + 'share.png',
    ];
    if ($('div').length > 0) {
        $.each($('div'), function (index, val) {
            var img = $(val).css('background-image').replace(/^url\((['"]?)(.*)\1\)$/, '$2');
            img = $.trim(img);
            if (img && img.match(/[^/]+(jpg|png|gif)$/)) {
                preloadImageList.push(img);
            }
        });
    }


preloadimages(preloadImageList, function () {

}, function (progress) {

});

// $('input[name=customize]').attr('placeholder','输入自定义文字（仅限四个字）').attr('maxlength','4');
$('input[name=tel]').attr('type','tel');
$('input[name=tel]').attr('maxlength',11);
$('.video-block').append('<video class="video" src="" x5-playsinline="" playsinline="" webkit-playsinline="" x-webkit-airplay="allow" x-webkit-airplay="true" ><video>');
$('.leafContainer').attr('id','leafContainer');
// $('.gif-block').html('<img src="'+ window.base_resource_url +'/image2/light.gif" class="gif" />')

if(window.type != 0 && window.tel == '')
{
    $('.prize-page').show();
    showPrize(window.type);
}
else 
{
    $('.page1').show();
}


var videoStatus = false;
var video = document.getElementsByClassName('video');
video = video[0];

var allowChangeTel = false;
var allowPrize = false;

var musicStatus = true;

$(document).ready(function () {
    $("input").on("blur",function(){
        window.scroll(0,0);//失焦后强制让页面归位
    });
    $('.logo').css('top',getTranslateDistance(15));
    $('.music').css('top',getTranslateDistance(40));
    $('.share').css('top',getTranslateDistance(25));
    initLeaves('leafContainer');

    $('.music').click(function(){
        if($('#music')[0].paused)
        {
            $('#music')[0].play();
            $('.music.stop').hide();
            $('.music.play').show();
            musicStatus = true;
        }
        else
        {
            $('#music')[0].pause();
            $('.music.play').hide();
            $('.music.stop').show();
            musicStatus = false;
        }
    });

    //显示活动规则
    $('.btn-rule').on('click', showRule);
    //隐藏活动规则
    $('.page1 .btn-close').on('click', hideRule);
    //首页跳转到城市选择页
    $('.page1 .btn-start').on('click', showMap);
    //哈尔滨
    $('.map-page .heb').on('click', {types: 'heb'}, handleCityClick);
    //北京
    $('.map-page .bj').on('click', {types: 'bj'}, handleCityClick);
    //上海
    $('.map-page .sh').on('click', {types: 'sh'}, handleCityClick);
    //三亚
    $('.map-page .sy').on('click', {types: 'sy'}, handleCityClick);
    //奖品页返回城市选择页
    $('.prize-page .btn-backtomap').on('click',backToMap);
    //手机号被修改
    $('input[name=tel]').on('input',changeTel);
    //提交手机号
    $('.prize-page .btn-submit').on('click',submitTel);
    //点击视频跳转抽奖
    $('.bj-img').on('click',tryPrize);
    //点击视频跳转抽奖
    $('.heb-img').on('click',tryPrize);
    //点击视频跳转抽奖
    $('.sh-img').on('click',tryPrize);
    //点击视频跳转抽奖
    $('.sy-img').on('click',tryPrize);
    //分享按钮
    $('.btn-share').on('click',showShare);
    //分享关闭
    $('.dialog-share').on('click',hideShare);
    
});

function showShare () {
    $('.dialog-share').fadeIn(300);
}
function hideShare () {
    $('.dialog-share').fadeOut(300);
}

function submitTel () {
    var tel = $('input[name=tel]').val();
    if(!tel.match(/^1\d{10}$/))
    {
        $('#notification_area').remove();
        my_notify('手机号码格式不正确');
        return false;
    }

    $.ajax({
        url: '/index/submit',
        type: 'POST',
        data: {
            tel: tel
        },
        success: function (resp) {
            if(resp.status == 1)
            {
                $('#notification_area').remove();
                my_notify('提交成功');
                window.tel = tel;
                $('.btn-submit').hide();
                allowChangeTel = true;
            }
        }
    })
}

function changeTel () {
    if($('input[name=tel]').val() != window.tel)
    {
        $('.prize-page .btn-submit').show();
    } else {
        $('.prize-page .btn-submit').hide();
    }
}

function backToMap () {
    $('.prize-page').hide();
    $('.map-page').show();
}

function videoPlay () {
    if(musicStatus) {
        $('#music')[0].pause();
    }
    video.removeEventListener('play',videoPlay);
}

function videoEnd () {
    if(musicStatus) $('#music')[0].play();
    $('.video-block').hide();
    allowPrize = true;
    video.removeEventListener('ended', videoEnd);
}

function tryPrize () {
    if(allowPrize)
    {
        allowPrize = false;
        if(window.type == 0)
        {
            $.ajax({
                url: '/index/tryprize',
                type: 'POST',
                success: function (resp) {
                    if(resp.status == 1 || resp.status == 0) {
                        $('.map-page').hide();
                        $('.prize-page').show();
                        $('.video-block,.heb-img,.sh-img,.sy-img,.bj-img').hide();
                        showPrize(resp.prize_type);
                        window.type = resp.prize_type;
                    }
                }
            });
        } else {
            $('.map-page').hide();
            $('.prize-page').show();
            $('.video-block,.heb-img,.sh-img,.sy-img,.bj-img').hide();
            showPrize(window.type);

            //提示领过奖并显示手机号
            $('#notification_area').remove();
            my_notify('您已经中过奖啦！');
            $('input[name=tel]').val(window.tel);
            $('.btn-submit').hide();
            allowChangeTel = true;
        }
    }
}

function handleCityClick (event) {

    //播放哈尔滨视频

    var v = '';
    if(event.data.types == 'sy') v = '-1';
    
    $('.video').attr('src', 'http://media.izhida.cn/' + event.data.types + v + '.mp4');
    $('.video')[0].play();
    $('.video-block').show();
    // if(window.browser.versions.android)
    // {
    //     $('.video-block').css('width','130%').css('left','-15%');
    // }

    setTimeout(function(){
        $('.'+ event.data.types +'-img').show();
    },10000)

    //视频播放事件
    video.addEventListener('play',videoPlay);
    //视频播放结束事件
    video.addEventListener('ended',videoEnd);

}

function showMap () {
    $('.page1').hide();
    $('.map-page').show();
}

function hideRule () {
    $('.dialog-rule').fadeOut(300);
}

function showRule () {
    $('.dialog-rule').fadeIn(300);
}

function showPrize (types) {
    //1 视频月卡
    //2 话费
    //0 未中奖
    $('.prize-page .prize-text').hide();
    if (types > 0) {
        var length = (types == 1) ? 2 : 3;
        $('.prize-page .prize' + types + '-' + RandomNumBoth(1,length)).show();
        $('.prize-page .tel-block').show();
    } else {
        $('.prize-page .tel-block').hide();
        $('.prize-page .no-prize').show();
    }
}

function getTranslateDistance(cardinal = 0) {
    var wrapInnerTransform = $('.wrap-inner').css('transform');
    var wrapInnertop = parseFloat($('.wrap-inner').css('top'));
    wrapInnerTransform = wrapInnerTransform.match(/^matrix\(1,\s0,\s0,\s1,\s0,\s\-?(\d+)/);
    wrapInnerTransform = parseFloat(wrapInnerTransform[1]);
    var wrapInnerjl = Math.abs(wrapInnertop - wrapInnerTransform);
    return wrapInnerjl + cardinal + 'px';
}

//获取随机数方法
//min 最小值
//max 最大值
function RandomNumBoth(Min,Max){
    var Range = Max - Min;
    var Rand = Math.random();
    var num = Min + Math.round(Rand * Range); //四舍五入
    return num;
}