module.exports = function (grunt) {
    grunt.initConfig({
        pkg: grunt.file.readJSON('package.json'),
        concat: {
            options: {
                //定义一个用于插入合并输出文件之间的字符
                separator: ';\n'
            },
            js: {
                //用于连接的文件
                src: [
                    './Public/static/js/jquery-notify.min.js',
                    './Public/static/js/index.min.js'
                ],
                //返回的JS文件位置
                dest: './Public/static/js//<%= pkg.name %>.min.js'
            }
        },
        uglify: {
            options: {
                sourceMap: false,
                mangle: true,
                compress: true,
                except: ['jQuery']
            },
            dest: {
                files: {
                    'Public/static/js/jquery-notify.min.js': ['Public/static/js/jquery-notify.js'],
                    'Public/static/js/index.min.js': ['Public/static/js/index.js']
                }
            }
        },

        compass: {
            dist: {
                options: {
                    config: 'config.rb'
                }
            }
        },
        cssmin: {
            options: {},
            target: {
                files: {
                    'Public/static/css/main_all.min.css': ['Public/static/css/notify.css', 'Public/static/css/main.css']
                }
            }
        },

        watch: {
            compass: {
                files: ['Public/static/css/*.scss'],
                tasks: ['compass']
            }
        }
    });
    grunt.registerTask('js_build', ['uglify', 'concat']);
    grunt.registerTask('css_build', ['compass', 'cssmin']);
    grunt.registerTask('default', ['js_build', 'css_build']);
    grunt.registerTask('dev', ['watch']);
    grunt.registerTask('compass', ['compass']);
    grunt.loadNpmTasks('grunt-contrib-concat');
    grunt.loadNpmTasks('grunt-contrib-uglify');
    grunt.loadNpmTasks('grunt-contrib-compass');
    grunt.loadNpmTasks('grunt-contrib-watch');
    grunt.loadNpmTasks('grunt-contrib-cssmin');
};